
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System.Xml;

using Microsoft.Xna.Framework;

namespace GE.Tools
{
    static class XmlHelper
    {
        public static float getFloatFromNode(XmlNode node)
        {
            return (float)double.Parse(node.InnerText);
        }

        public static int getIntFromNode(XmlNode node)
        {
            return int.Parse(node.InnerText);
        }

        public static string getStringFromNode(XmlNode node)
        {
            return node.InnerText;
        }

        public static Vector2 getVector2FromNode(XmlNode node)
        {
            string[] separated = node.InnerText.Split(' ');

            return new Vector2(float.Parse(separated[0]), float.Parse(separated[1]));
        }

        public static Vector2 getVector2FromAttribute(XmlAttribute a)
        {
            string[] separated = a.InnerText.Split(' ');
            return new Vector2(float.Parse(separated[0]), float.Parse(separated[1]));
        }

        public static Vector3 getVector3FromNode(XmlNode node)
        {
            string[] separated = node.InnerText.Split(' ');

            return new Vector3(float.Parse(separated[0]), float.Parse(separated[1]), float.Parse(separated[2]));
        }

        public static float getFloatFromAttribute(XmlAttribute a)
        {
            return float.Parse(a.InnerText);
        }

        public static int getIntFromAttribute(XmlAttribute a)
        {
            return int.Parse(a.InnerText);
        }

        public static string getStringFromAttribute(XmlAttribute a)
        {
            return a.InnerText;
        }

        public static bool getBoolFromAttribute(XmlAttribute a)
        {
            if (a.InnerText == "true" || a.InnerText == "True")
                return true;
            else
                return false;
        }

        public static string[] getWordsFromNode(XmlNode node)
        {
            return node.InnerText.Split(' ');
        }

    }
}